/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.mu;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.UUIDImpl;
import com.cisco.pt.mu.MultiUserMessage;

public class MUNegotiationMessage
extends MultiUserMessage {
    private String username = "Guest";
    private UUID uuid = null;

    public MUNegotiationMessage(String username, UUID uuid) {
        super.setType(PTMP_TYPE_MUNEGOREQ);
        this.uuid = uuid == null ? UUIDImpl.makeRandom() : uuid;
        this.username = username;
    }

    public MUNegotiationMessage() {
        super.setType(PTMP_TYPE_MUNEGOREQ);
        this.uuid = this.uuid == null ? UUIDImpl.makeRandom() : this.uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public static MUNegotiationMessage getMessage(EncodedBuffer buffer) {
        MUNegotiationMessage msg = new MUNegotiationMessage();
        msg.username = buffer.getString();
        msg.uuid = buffer.getUUID();
        return msg;
    }

    public void serialize(EncodedBuffer buffer) {
        buffer.putInt(super.getType());
        buffer.putString(this.username);
        buffer.putUUID(this.uuid);
    }

    public String toString() {
        String str = new String();
        str = "[MUNegotiationMessage: \n";
        str = str + "   username: " + this.username + "\n";
        str = str + "       uuid: " + this.uuid + "\n";
        str = str + "]";
        return str;
    }

    public void encodeTypeAndPayload(EncodedBuffer buff) {
        buff.putInt(super.getType());
        buff.putString(this.username);
        buff.putUUID(this.uuid);
        buff.flip();
    }
}

